#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <limits>

using namespace std;

struct Tacka {
    long long x, y;
};

int orijentacija(const Tacka& p, const Tacka& q, const Tacka& r) {
    long long vrednost = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    return (vrednost > 0) - (vrednost < 0);
}

long long rastojanjeKvadrat(const Tacka& p1, const Tacka& p2) {
    return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
}

vector<Tacka> konveksniOmotac(vector<Tacka>& tacke) {
    int n = tacke.size();
    if (n < 3) return {};

    sort(tacke.begin(), tacke.end(), [](const Tacka& a, const Tacka& b) {
        return (a.x < b.x) || (a.x == b.x && a.y < b.y);
        });

    vector<Tacka> omotac;
    for (const auto& p : tacke) {
        while (omotac.size() >= 2 && orijentacija(omotac[omotac.size() - 2], omotac.back(), p) != -1) {
            omotac.pop_back();
        }
        omotac.push_back(p);
    }

    int donjiOmotacVelicina = omotac.size();
    for (int i = n - 1; i >= 0; i--) {
        while (omotac.size() > donjiOmotacVelicina && orijentacija(omotac[omotac.size() - 2], omotac.back(), tacke[i]) != -1) {
            omotac.pop_back();
        }
        omotac.push_back(tacke[i]);
    }

    omotac.pop_back();

    return omotac;
}

long long povrsinaPoligona(const vector<Tacka>& omotac) {
    long long povrsina = 0;
    int n = omotac.size();
    for (int i = 0; i < n; i++) {
        const Tacka& p1 = omotac[i];
        const Tacka& p2 = omotac[(i + 1) % n];
        povrsina += p1.x * p2.y - p2.x * p1.y;
    }
    return abs(povrsina);
}

long long minimalniSkoroOmotac(vector<Tacka>& tacke) {
    int n = tacke.size();
    long long najmanjaPovrsina = numeric_limits<long long>::max();

    for (int i = 0; i < n; i++) {
        vector<Tacka> podskup;
        for (int j = 0; j < n; j++) {
            if (j != i) {
                podskup.push_back(tacke[j]);
            }
        }

        vector<Tacka> omotac = konveksniOmotac(podskup);

        long long povrsina = povrsinaPoligona(omotac);
        najmanjaPovrsina = min(najmanjaPovrsina, povrsina);
    }

    return najmanjaPovrsina / 2;
}

int main() {
    int n;
    cin >> n;

    vector<Tacka> tacke(n);
    for (int i = 0; i < n; i++) {
        cin >> tacke[i].x >> tacke[i].y;
    }

    long long najmanjaPovrsina = minimalniSkoroOmotac(tacke);

    cout << najmanjaPovrsina << endl;

    return 0;
}